#pragma once

#include "resource.h"
#include "SkinLib/SkinLib.h"
#include "QQClient/QQClient.h"
#include "Utils.h"
#include "FontSelDlg.h"

#define		WM_UPDATE_FONTINFO		WM_USER + 2

extern CFontInfo g_fontInfo;				// Ϣ
extern TCHAR g_cHotKey;						// ȡϢȼ

BOOL LoadMiscConfig(LPCTSTR lpszFileName);	// 
BOOL SaveMiscConfig(LPCTSTR lpszFileName);	// 

class CFontSelDlg : public CDialogImpl<CFontSelDlg>
{
public:
	CFontSelDlg(void);
	~CFontSelDlg(void);

	enum { IDD = IDD_FONTSELDLG };

	BEGIN_MSG_MAP_EX(CFontSelDlg)
		MSG_WM_INITDIALOG(OnInitDialog)
		MSG_WM_CLOSE(OnClose)
		MSG_WM_DESTROY(OnDestroy)
		COMMAND_ID_HANDLER_EX(101, OnBtn_SysFont)
		COMMAND_ID_HANDLER_EX(102, OnBtn_MemberFont)
		COMMAND_HANDLER_EX(ID_COMBO_FONTNAME, CBN_SELCHANGE, OnCbo_SelChange_FontName)
		COMMAND_HANDLER_EX(ID_COMBO_FONTSIZE, CBN_SELCHANGE, OnCbo_SelChange_FontSize)
		COMMAND_ID_HANDLER_EX(104, OnBtn_Bold)
		COMMAND_ID_HANDLER_EX(105, OnBtn_Italic)
		COMMAND_ID_HANDLER_EX(106, OnBtn_UnderLine)
		COMMAND_HANDLER_EX(107, BN_CLICKED, OnBtn_Color)
	END_MSG_MAP()

public:
	CFontInfo& GetPublicFontInfo();		// ȡȫϢ
	CFontInfo& GetFontInfo();			// ȡϢ

private:
	BOOL OnInitDialog(CWindow wndFocus, LPARAM lInitParam);
	void OnClose();
	void OnDestroy();
	void OnBtn_SysFont(UINT uNotifyCode, int nID, CWindow wndCtl);		// ϵͳ塱ť
	void OnBtn_MemberFont(UINT uNotifyCode, int nID, CWindow wndCtl);	// ԱŲ֡ť
	void OnCbo_SelChange_FontName(UINT uNotifyCode, int nID, CWindow wndCtl);	// ơϿ
	void OnCbo_SelChange_FontSize(UINT uNotifyCode, int nID, CWindow wndCtl);	// СϿ
	void OnBtn_Bold(UINT uNotifyCode, int nID, CWindow wndCtl);			// Ӵ֡ť
	void OnBtn_Italic(UINT uNotifyCode, int nID, CWindow wndCtl);		// бť
	void OnBtn_UnderLine(UINT uNotifyCode, int nID, CWindow wndCtl);	// »ߡť
	void OnBtn_Color(UINT uNotifyCode, int nID, CWindow wndCtl);		// ɫť

	BOOL InitFontClassToolBar();	// ʼ๤
	BOOL InitFontNameComboBox();	// ʼϿ
	BOOL InitFontSizeComboBox();	// ʼСϿ
	BOOL InitFontAttrToolBar();		// ʼԹ

	BOOL Init();					// ʼ
	void UnInit();					// ʼ

private:
	CSkinDialog m_SkinDlg;
	CSkinToolBar m_tbFontClass, m_tbFontAttr;
	CSkinComboBox m_cboFontName, m_cboFontSize;
	CFontInfo m_fontInfo;
};
